/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.control.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.widgets.Display;

public class TerminalInputStream
extends InputStream {
    private final int fUITimeout;
    protected final OutputStream fOutputStream = new TerminalOutputStream();
    private final Runnable fNotifyChange;
    static Timer fgTimer = new Timer(false);
    private final BoundedByteBuffer fQueue;
    final int BLOCK_SIZE = 64;
    private Runnable fRunnable;
    private boolean fEnoughDisplayTime;

    public TerminalInputStream(int bufferSize, int uiTimeout, Runnable notifyChange) {
        this.fNotifyChange = notifyChange;
        this.fQueue = new BoundedByteBuffer(bufferSize);
        this.fUITimeout = uiTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bytesAreAvailable() {
        BoundedByteBuffer boundedByteBuffer = this.fQueue;
        synchronized (boundedByteBuffer) {
            if (this.fRunnable == null) {
                this.fRunnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        BoundedByteBuffer boundedByteBuffer = TerminalInputStream.this.fQueue;
                        synchronized (boundedByteBuffer) {
                            TerminalInputStream.this.fRunnable = null;
                        }
                        TerminalInputStream.this.startTimer(TerminalInputStream.this.fUITimeout);
                        TerminalInputStream.this.fNotifyChange.run();
                    }
                };
                Display.getDefault().asyncExec(this.fRunnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startTimer(int milliSec) {
        BoundedByteBuffer boundedByteBuffer = this.fQueue;
        synchronized (boundedByteBuffer) {
            this.fEnoughDisplayTime = false;
        }
        fgTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BoundedByteBuffer boundedByteBuffer = TerminalInputStream.this.fQueue;
                synchronized (boundedByteBuffer) {
                    TerminalInputStream.this.fEnoughDisplayTime = true;
                    if (TerminalInputStream.this.fQueue.size() > 0) {
                        TerminalInputStream.this.bytesAreAvailable();
                    }
                }
            }
        }, milliSec);
    }

    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        int available;
        BoundedByteBuffer boundedByteBuffer = this.fQueue;
        synchronized (boundedByteBuffer) {
            block5: {
                if (!this.fEnoughDisplayTime) break block5;
                return 0;
            }
            available = this.fQueue.size();
        }
        if (available > 64) {
            available = 64;
        }
        return available;
    }

    public int read() throws IOException {
        try {
            return this.fQueue.read();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return -1;
        }
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] cbuf, int off, int len) throws IOException {
        int n = 0;
        BoundedByteBuffer boundedByteBuffer = this.fQueue;
        synchronized (boundedByteBuffer) {
            try {
                while (this.fQueue.size() > 0 && n < len && n < 64) {
                    cbuf[off + n] = this.fQueue.read();
                    ++n;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return n;
    }

    class BoundedByteBuffer {
        protected final byte[] fBuffer;
        protected int fPutPos = 0;
        protected int fTakePos = 0;
        protected int fUsedSlots = 0;

        public BoundedByteBuffer(int capacity) throws IllegalArgumentException {
            if (capacity < 64) {
                capacity = 128;
            }
            if (capacity <= 0) {
                throw new IllegalArgumentException();
            }
            this.fBuffer = new byte[capacity];
        }

        public synchronized int size() {
            return this.fUsedSlots;
        }

        public synchronized void write(byte b) throws InterruptedException {
            while (this.fUsedSlots == this.fBuffer.length) {
                this.wait();
            }
            this.fBuffer[this.fPutPos] = b;
            this.fPutPos = (this.fPutPos + 1) % this.fBuffer.length;
            if (this.fUsedSlots++ == 0) {
                this.notifyAll();
            }
        }

        public synchronized byte read() throws InterruptedException {
            while (this.fUsedSlots == 0) {
                this.wait();
            }
            byte b = this.fBuffer[this.fTakePos];
            this.fTakePos = (this.fTakePos + 1) % this.fBuffer.length;
            if (this.fUsedSlots-- == this.fBuffer.length) {
                this.notifyAll();
            }
            return b;
        }
    }

    class TerminalOutputStream
    extends OutputStream {
        TerminalOutputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                int noff = off;
                int end = off + len;
                while (noff < end) {
                    int n = noff + 64;
                    if (n > end) {
                        n = end;
                    }
                    BoundedByteBuffer boundedByteBuffer = TerminalInputStream.this.fQueue;
                    synchronized (boundedByteBuffer) {
                        int i = noff;
                        while (i < n) {
                            TerminalInputStream.this.fQueue.write(b[i]);
                            ++i;
                        }
                        TerminalInputStream.this.bytesAreAvailable();
                    }
                    noff += 64;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int b) throws IOException {
            try {
                BoundedByteBuffer boundedByteBuffer = TerminalInputStream.this.fQueue;
                synchronized (boundedByteBuffer) {
                    TerminalInputStream.this.fQueue.write((byte)b);
                    TerminalInputStream.this.bytesAreAvailable();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

